﻿using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// OrderableTestModel
    /// </summary>
    public class OrderableTestModel
    {
        /// <summary>
        /// Orderable Test Id (enum)
        /// </summary>
        public OrderableTest OrderableTestId { get; private set; }
        /// <summary>
        /// Name
        /// </summary>
        public string Name { get; private set; }
        /// <summary>
        /// DisplayName
        /// </summary>
        public string DisplayName
        {
            get
            {
                if (IsWeakD)
                {
                    return "Weak D";
                }

                return Name;
            }
        }
        /// <summary>
        /// Is WeakD
        /// </summary>
        public bool IsWeakD
        {
            get
            {
                return (OrderableTestId == OrderableTest.AGwD);
            }
        }
        /// <summary>
        /// IsRepeat
        /// </summary>
        public bool IsRepeat
        {
            get
            {
                return Name.IndexOf("repeat", StringComparison.InvariantCultureIgnoreCase) >= 0;
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="orderableTestId"></param>
        /// <param name="name"></param>
        public OrderableTestModel(int orderableTestId, string name)
        {
            OrderableTestId = (OrderableTest)orderableTestId;
            Name = name;
        }
    }
}
